/* OmniPPCCounters.h created by bungi on Wed 14-Oct-1998 */


//
// These are the performance monitoring events defined on the PPC.
// See the PPC 750 manual for more details on exactly what each
// of these counts.
//



// Common to all four counters

#define OPPC_PMC_HOLD                    0
#define OPPC_PMC_CYCLES                  1
#define OPPC_PMC_INSTRUCTIONS_COMPLETED  2
#define OPPC_PMC_TIME_TRANSITIONS        3
#define OPPC_PMC_INSTRUCTIONS_DISPATCHED 4


// Common to PMC1 and PMC2
#define OPPC_PMC12_EIEIO_COMPLETED               5
#define OPPC_PMC12_ITLB_SEARCH_CYCLES            6
#define OPPC_PMC12_L2_HITS                       7
#define OPPC_PMC12_INSTRUCTION_EA                8
#define OPPC_PMC12_IABR_HITS                     9
#define OPPC_PMC12_L1_MISS_THRESHOLD            10
#define OPPC_PMC12_UNRESOLVED_BRANCHES          11
#define OPPC_PMC12_DISPATCH_BRANCH_STALL_CYCLES 12
#define OPPC_PMC12_LAST                         OPPC_PMC12_DISPATCH_BRANCH_STALL_CYCLES

// PMC3
#define OPPC_PMC3_L1_DATA_MISSES               5
#define OPPC_PMC3_DTLB_MISSES                  6
#define OPPC_PMC3_L2_DATA_MISSES               7
#define OPPC_PMC3_BRANCHES_TAKEN               8
#define OPPC_PMC3_MARKED_TASK_TRANSISTIONS     9
#define OPPC_PMC3_STORE_CONDITIONALS_COMPLETED 10
#define OPPC_PMC3_FPU_INSTRUCTIONS_COMPLETED   11
#define OPPC_PMC3_L2_SNOOP_CASTOUTS            12
#define OPPC_PMC3_L2_CACHE_HITS                13 // different from OPPC_PMC12_L2_HITS
#define OPPC_PMC3_RESERVED0                    14
#define OPPC_PMC3_L1_MISS_CYCLES               15
#define OPPC_PMC3_CORRECT_BRANCH_SPECULATIONS  16
#define OPPC_PMC3_BPU_LRCR_STALL_CYCLES        17
#define OPPC_PMC3_LAST                         OPPC_PMC3_BPU_LRCR_STALL_CYCLES

// PMC4
#define OPPC_PMC4_L2_CASTOUTS                  5 // different from OPPC_PMC3_L2_SNOOP_CASTOUTS
#define OPPC_PMC4_DTLB_SEARCH_CYCLES           6
#define OPPC_PMC4_RESERVED0                    7
#define OPPC_PMC4_MISPREDICTED_BRANCHES        8
#define OPPC_PMC4_MARKED_TASK_TRANSISTIONS     9 // not clear if this is different from the one in PMC3
#define OPPC_PMC4_STORE_CONDITIONALS_RSV       10
#define OPPC_PMC4_SYNC_INSTRUCTIONS            11
#define OPPC_PMC4_SNOOP_RETRIES                12
#define OPPC_PMC4_INT_INSTRUCTIONS_COMPLETED   13
#define OPPC_PMC4_BPU_FULL                     14
#define OPPC_PMC4_LAST                         OPPC_PMC4_BPU_FULL

