
#import <Foundation/Foundation.h>
#import <OmniPPCPerformanceCounter/OmniPPCPerformanceCounter.h>
#import <mach/mach_error.h>

void blegga(unsigned int count, unsigned int *a)
{
    
}

int main (int argc, const char *argv[])
{
    NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
    OPPCSPR            start[4], end[4];
    unsigned int       count, i;
    int                rc;
    
    // Count on marked users tasks
    rc = OPPCSetup(NO, YES, NO, NO, YES);
    if (rc < 0) {
        exit(1);
    }
    
    rc = OPPCSelect(OPPC_PMC_CYCLES,
                    OPPC_PMC_INSTRUCTIONS_COMPLETED,
                    OPPC_PMC3_DTLB_MISSES,
                    OPPC_PMC4_INT_INSTRUCTIONS_COMPLETED);
    if (rc < 0) {
        exit(1);
    }

    OPPCSetMarked(1);

    rc = OPPCReset(YES, YES, YES, YES);
    if (rc < 0) {
        exit(1);
    }

    //
    // Timing start
    //
    OPPC_PMC_GET(start);
//    start[0] = 100;
//    start[1] = 200;
//    start[2] = 300;
//    start[3] = 400;
    
#if 0
    // Call an external assembly function
    {
        extern void testFunc2(unsigned int count, unsigned int *a);
        unsigned int a[16] = {
            0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0
        };
        
        count = 0x000f4240; // 1000000
        testFunc2(count, a);
    }
#endif

#if 1
    {
        unsigned int toSum[10000];

        count = 10000;
        blegga(count,toSum);
    }
#endif
    
    //
    // Timing end
    //
    OPPC_PMC_GET(end);
//    end[0] = 1;
//    end[1] = 1;
//    end[2] = 1;
//    end[3] = 1;

    printf("start[0] = %d (%f)\n", start[0], (float)start[0]);
    
    for (i = 0; i < 4; i++) {
        unsigned int s, e, delta;
        double fdelta, fcount;
        
        s     = start[i];
        e     = end[i];
        printf("s = %u (%f), e = %u (%f)\n", s, (float)s, e, (float)e);
        delta = e - s;
        printf("delta = %u\n", delta);

        fdelta = (double)delta;
        fcount = (double)count;
        printf("delta = %f, count = %f\n", fdelta, fcount);
        

        printf("delta = %f, count = %f\n", (float)delta, (float)count);

        printf("counter[%d] = % 8d\t%04.2f per loop\t%0.2f per cycle\n",
               i, delta, (float)delta/(float)count, (float)delta/(end[0]-start[0]));
    }

    printf("cycles/instruction = %0.2f\n", (float)(end[1]-start[1])/(end[0]-start[0]));

    OPPCSetMarked(0);
    
    [pool release];
    exit(0);       // insure the process exit status is 0
    return 0;      // ...and make main fit the ANSI spec.
}
