#import <OmniTimer/OTTimer.h>
#import <libc.h>

int main (int argc, const char *argv[])
{
    OTStamp start, sum;
    int secondsToTime = 10;

    if (argc > 2) {
        fprintf(stderr, "usage: %s [secondsToTime]\n", argv[0]);
        exit(1);
    }

    if (argc == 2)
        sscanf(argv[1], "%d", &secondsToTime);
    fprintf(stderr, "Timing clock speed for %d seconds...\n", secondsToTime);
    
    OTZeroStamp(&sum);
    OTSetClockSpeed(1.0);
    
    OTReadCounter(&start);
    sleep(secondsToTime);
    OTAddDeltaSinceStart(&start, &sum);

    fprintf(stderr, "Cycles per second = %f\n",
            OTStampToSeconds(&sum) / (float) secondsToTime);
    return 0;
}
