#import "OPPCConnect.h"
#import "OPPCUtils.h"

#import <mach/mach.h>
#import <mach/mach_error.h>
#import <pthread.h>

#import "../Driver/OmniPPCPerformanceCounterDriver.kmodproj/OmniPPCPerformanceCounterDriver.h"

#import <unistd.h>  // for syscall()

int OPPCSetup(int disableCountingUnconditionally,
              int disableCountingInSupervisorMode,
              int disableCountingInUserMode,
              int disableCountingForMarkedTasks,
              int disableCountingForUnmarkedTasks)
{
    if (syscall(OPPC_SYSCALL, OPPCSetupOperation,
                disableCountingUnconditionally,
                disableCountingInSupervisorMode,
                disableCountingInUserMode,
                disableCountingForMarkedTasks,
                disableCountingForUnmarkedTasks)) {
        perror("OPPCSetup");
        return -1;
    }
    return 0;
}

                     
int OPPCSelect(int event1, int event2, int event3, int event4)
{
    if (syscall(OPPC_SYSCALL, OPPCSelectOperation,
                event1, event2, event3, event4)) {
        perror("OPPCSelect");
        return -1;
    }
    return 0;
}

int OPPCReset(int reset1, int reset2, int reset3, int reset4)
{
    if (syscall(OPPC_SYSCALL, OPPCResetOperation,
                reset1, reset2, reset3, reset4)) {
        perror("OPPCSelect");
        return -1;
    }
    return 0;
}

//
// You aren't supposed to modify your own thread state, so
// we'll have a helper thread modify it for us.
//

static pthread_t        helperThread;
static pthread_mutex_t  helperMutex;
static pthread_cond_t   helperCondition;
static thread_t         helperTargetThread      = THREAD_NULL;
static boolean_t        helperTargetThreadState = 0;

static void *_OPPCSetMarkedHelper(void *arg)
{
    unsigned int pmBit = (1<<2);
    
    while (1) {
        struct ppc_thread_state state;
        unsigned int            stateCount;
        kern_return_t           rc;

        pthread_mutex_lock(&helperMutex);
        while (helperTargetThread == THREAD_NULL)
            pthread_cond_wait(&helperCondition, &helperMutex);

        // Get the current state
        stateCount = MACHINE_THREAD_STATE_COUNT;
        rc = thread_get_state(helperTargetThread, MACHINE_THREAD_STATE, (natural_t *)&state, &stateCount);
        if (rc != KERN_SUCCESS) {
            mach_error("_OPPCSetMarkedHelper", rc);
            exit(1);
        }

        //printf("State was %d.\n", state.srr1 & pmBit);
        
        // Set the bit to the correct state
        if (helperTargetThreadState)
            state.srr1 |= pmBit;
        else
            state.srr1 &= ~pmBit;

        // Set the new state
        stateCount = MACHINE_THREAD_STATE_COUNT;
        rc = thread_set_state(helperTargetThread, MACHINE_THREAD_STATE, (natural_t *)&state, stateCount);
        if (rc != KERN_SUCCESS) {
            mach_error("_OPPCSetMarkedHelper", rc);
            exit(1);
        }

        helperTargetThread = THREAD_NULL;
        pthread_cond_signal(&helperCondition);
        pthread_mutex_unlock(&helperMutex);
    }
}


void OPPCSetMarked(boolean_t yn)
{
    if (!helperThread) {
        // Setup everything
        pthread_mutex_init(&helperMutex, NULL);
        pthread_cond_init(&helperCondition, NULL);

        pthread_create(&helperThread, NULL, _OPPCSetMarkedHelper, NULL);
        pthread_detach(helperThread);
    }

    pthread_mutex_lock(&helperMutex);
    
    helperTargetThread = mach_thread_self();
    helperTargetThreadState = yn;
    pthread_cond_signal(&helperCondition);

    while (helperTargetThread != THREAD_NULL)
        pthread_cond_wait(&helperCondition, &helperMutex);
    pthread_mutex_unlock(&helperMutex);
}


#if 0

unsigned long long ppc_counter1 = 0, ppc_counter2 = 0, ppc_counter3 = 0, ppc_counter4 = 0;
unsigned long      ppc_count = 0;

static unsigned int ppc_start1, ppc_end1;
static unsigned int ppc_start2, ppc_end2;
static unsigned int ppc_start3, ppc_end3;
static unsigned int ppc_start4, ppc_end4;

void OPPCTimerStart()
{
    ppc_count++;
    OPPCSync();
    ppc_start1 = OPPCGetPMC1();
    ppc_start2 = OPPCGetPMC2();
    ppc_start3 = OPPCGetPMC3();
    ppc_start4 = OPPCGetPMC4();
}


void OPPCTimerEnd()
{
    OPPCSync();
    ppc_end1 = OPPCGetPMC1();
    ppc_end2 = OPPCGetPMC2();
    ppc_end3 = OPPCGetPMC3();
    ppc_end4 = OPPCGetPMC4();
    ppc_counter1 += (ppc_end1 - ppc_start1);
    ppc_counter2 += (ppc_end2 - ppc_start2);
    ppc_counter3 += (ppc_end3 - ppc_start3);
    ppc_counter4 += (ppc_end4 - ppc_start4);
}

#endif

